dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 5, 220, 260, "assets/images/table/redtable_6", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 2, 3, 250, 410, "assets/images/table/redtable", "assets/images/food/item_mark2", "R" );

useFloAsServer = 0;
useWineTable = 0;
numMoodBoosts = 0;
numServers = 1;
maxCoupleHappiness = 250;


-- Group 1
guest = LManager.GenGuest(female03);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(1, 3, 3000);

-- Group 2

guest = LManager.GenGuest(female01);
guest.matchType = NOT_GUEST + male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = aunt;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(4, 6, 13000);


-- Group 3

guest = LManager.GenGuest(female01);
guest.matchType = NOT_GUEST + aunt;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(7, 7, 35000);

-- Group 4


guest = LManager.GenGuest(male04);
guest.matchType = NOT_GUEST + female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = NOT_GUEST + male04;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(8, 9, 60000);


-- Group 6

guest = LManager.GenGuest(female04);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = NOT_GUEST + female04;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(10, 11, 90000);

-- Group 7

guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(12, 12, 110000);


LManager:AdjustGuestTolerance(150);

LManager:SetLevelSetting ("bridesmaidsDelay", 100000); 
LManager:SetLevelSetting ("bridesmaidsChance", 100);

-- Custom event - effects path, x, y, delay
LManager:AddQuinnEvent( "fx/fx_bees.lua", 600, 300, 60000 );


-- Set up the Level Settings
LManager:SetLevelNumber(1,9);
LManager:SetLevelScores(3600, 5500);
LManager:SetLevelTime(300000);
LManager:SetLevelSetting ("blaster", 0);

LManager:SetMusic("assets/audio/music/Big Band 4.ogg","assets/audio/music/Uptempo_3.ogg","assets/audio/music/Disco Dance 1.ogg");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );